WheelieScript = {};

source(g_currentModDirectory.."WheelieEvent.lua");

local WheelieScriptEventId = nil;

function WheelieScript:loadMap(savegame)
    if g_currentMission:getIsClient() then
        Enterable.onRegisterActionEvents = Utils.appendedFunction(Enterable.onRegisterActionEvents, WheelieScript.registerActionEvents);
    end
end

function WheelieScript:registerActionEvents()
    if self.isClient then
        WheelieScript.events = {}
		local valid1, eventId1 = g_inputBinding:registerActionEvent(InputAction.WHEELIEACTION,"WHEELIEACTION",WheelieScript.WheelieEvent,false,true,false,true)
        if valid1 then
            table.insert(WheelieScript.events, eventId1);
            g_inputBinding:setActionEventTextVisibility(eventId1, true);
            WheelieScriptEventId = eventId1;
        end
    end
end

function WheelieScript:WheelieEvent(actionName, keyStatus, arg3, arg4, arg5)
end;

function WheelieScript:updateActionEvents()
	if WheelieScriptEventId ~= nil then
		if g_currentMission.controlledVehicle ~= nil and g_currentMission.controlledVehicle:getLastSpeed() < 1 then
			g_inputBinding:setActionEventActive(WheelieScriptEventId,true);
		else
			g_inputBinding:setActionEventActive(WheelieScriptEventId,false);
		end;
	end;
end

function WheelieScript:RotateVehicle(Vehicle,x,y,z)
	local Rx,Ry,Rz = localDirectionToWorld(Vehicle.rootNode,x,y,z);
	setAngularVelocity(Vehicle.rootNode,Rx,Ry,Rz);
end;

local InWheelie = false;
local InputMode = false;

function WheelieScript:WheelieUpdate()	
	local CurrentSpeed = g_currentMission.controlledVehicle:getLastSpeed();
	if CurrentSpeed > 1 and InWheelie == true then 
		local Vector = CurrentSpeed/10;
		if Vector > 0.7 then Vector = 0.7 end;
		g_client:getServerConnection():sendEvent(WheelieEvent.new(g_currentMission.controlledVehicle,-Vector));
	end;
end;

function WheelieScript:update()	
	if g_currentMission.controlledVehicle and InWheelie == false and Input.isKeyPressed(Input.KEY_lshift) and g_currentMission.controlledVehicle:getLastSpeed() < 1 then
	    InputMode = false;
		InWheelie = true;
	end;

	if g_currentMission.controlledVehicle and InWheelie == false and getInputButton(Input.BUTTON_11,0) == 1 and g_currentMission.controlledVehicle:getLastSpeed() < 1 then
	    InputMode = true;
		InWheelie = true;
	end;

	if InWheelie == true and InputMode == false and Input.isKeyPressed(Input.KEY_lshift) == false then InWheelie = false; end; 
	if InWheelie == true and InputMode == true and getInputButton(Input.BUTTON_11,0) ~= 1 then InWheelie = false; end; 

	if g_currentMission.controlledVehicle then WheelieScript:WheelieUpdate(); end;

	WheelieScript:updateActionEvents();
end;

addModEventListener(WheelieScript);